# -*- coding: utf-8 -*-
"""
Action d'un filtre d'ordre 1 sur un signal sinusoïdal

"""

#### Importation des bibliothèques utiles

import numpy as np
import matplotlib.pyplot as plt


# Constantes du filtre d'ordre 1
#---------------------------------------------------------------
fc = 100            # fréquence de coupure (Hz)
H0 = 1              # gain en basse fréquence
#---------------------------------------------------------------

# Fonction de transfert H = H0*num/(1 + j f/fc) ; choisir num
def H(H0, fc, f):
    #num = 1                     # passe-bas
    num = 1j*f/fc                # passe-haut
    return H0*num /(1 + 1j*f/fc)

#Définition du diagramme de Bode
n = 2000                                # nombre de points
f = np.logspace(-2, 2, n+1)*fc          # n intervalles, entre 10^-2fc et 10^2fc ; n+1 valeurs
GdB = 20*np.log10(np.abs(H(H0, fc, f)))
phi = np.angle(H(H0, fc, f), deg=True)


#Tracé de GdB et phi en concordance de fréquence
plt.figure(1)
plt.subplot(211)
plt.semilogx(f, GdB, 'b')
plt.title('Diagramme de Bode, H0='+str(H0) + ' fc ='+str(fc)+'Hz')
plt.ylabel('GdB')
plt.grid()

plt.subplot(212)
plt.semilogx(f, phi, 'b')
plt.ylabel('phase (°)')
plt.xlabel('f (Hz)')
plt.grid()

#plt.show()


# Signal d'entrée : ue(t) = U0 + U1cos(2*pi*f*t + phie)

fe = 10
                                 # fréquence du signal d'entrée (en Hz)
F = [0, fe]                                  # liste des fréquences des raies

U0 = 2                                       # valeur moyenne (V)
U1 = 1                                       # amplitude du fondamental (V)
phie1 = 0                                    # phases à l'origine (°)

Ue = [U0, U1]                                # liste des amplitudes
phie = [0, phie1]                            # liste des phases


# Action du filtre sur chaque raie du signal d'entrée
def ordre_1(H0, fc, F, U) :                 # ici U est pour le moment une variable muette
	Hs   = H(H0, fc, F)
	Us   = np.abs(Hs) * U
	phis = np.angle(Hs, deg=True)
	return Us, phis

Hs0   = H(H0, fc, F[0])
Us0 = np.abs(Hs0)*U0

Hs1   = H(H0, fc, F[1])
Us1 = np.abs(Hs1)*U1
phis1 = np.angle(Hs1, deg=True) + phie1

Us = [Us0, Us1]
phis = [0, phis1]

## Superposition des spectres d'entrée et sortie

largeur = fe/50                                 # largeur des raies
Fg = [F[i] - largeur/2 for i in range(len(F))]  #raies de ue(t) à gauche de f
Fd = [F[i] + largeur/2 for i in range(len(F))]  #raies de us(t) à droite de f


plt.figure(2)
ax1 = plt.subplot(211)					                                 # figure 2 lignes, 1 colonne
ax1.bar(Fg, Ue, largeur, label='Uem fe ='+ str(fe)+'Hz')                 # spectre de Ue
ax1.bar(Fd, Us, largeur, label='Usm pour fc =' + str(fc) + 'Hz')        # spectre de Us
ax1.set_ylabel('U (V)')
ax1.set_title('Spectres en amplitude et en phase')
ax1.set_xticks(F)
ax1.legend()
ax1.grid()

ax2 = plt.subplot(212)                                                 # tracé des phases en concordance de f
ax2.bar(Fg, phie, largeur, label='phie')                               # spectre pour phie
ax2.bar(Fd, phis, largeur, label='phis pour fc ='+str(fc)+'Hz')        # spectre pour phis
ax2.set_xticks(F)
ax2.set_xlabel('f (Hz)')
ax2.set_ylabel('phase (°)')
ax2.legend(loc='lower center')
ax2.grid()

## Tracés de ue(t) et us(t)

t = np.linspace(0, 4/fe, 1001)                                # tracé entre t = 0 et t(max) = 4T = 4/fe (tableau)
ue = U0 + U1*np.cos(2*np.pi*F[1]*t + phie1*np.pi/180)         # signal d'entrée
us = Us0 + Us1*np.cos(2*np.pi*F[1]*t + phis1*np.pi/180)       # signal de sortie

plt.figure(3)
plt.plot(t, ue, label = 'ue')  # t est une liste, ue(t) aussi
plt.plot(t, us, label = 'us')
plt.xlabel('t (en s)'), plt.ylabel('en V')
plt.title('Tracés de ue(t) et us(t) pour fc =' + str(fc) + ' Hz et fe =' + str(fe) + 'Hz')
plt.grid()
plt.legend()
plt.show()